classdef class_REVS_starter
    %UNTITLED Summary of this class goes here
    %   Detailed explanation goes here
    
    properties
        
        cranking_speed_radps;			% Approximate starter craking speed at engine crankshaft [rad/sec]
        efficiency_norm = 0.5;			% Starter efficiency [0-1]
        inertia_kgm2 = 0;				% Starter Rotational inertia measured at engine crankshaft [kg/m^2]
        rated_voltage_V = 12;            % assume 12V starter unless the param file specifies otherwise
        min_voltage_V = [];				% Starter minimum operational voltage [V]
        max_torque_Nm;					% Starter maximum output torque [Nm]
    end
    
    methods
        
        function obj = class_REVS_starter( engine )
            if nargin > 0
                obj.cranking_speed_radps = min(engine.idle_speed_radps.table(:)) / 3;
                obj.max_torque_Nm = engine.inertia_kgm2 * 1000.0;
            end
        end
        
        function val = get.min_voltage_V(obj)
            val = REVS_class_default(obj.min_voltage_V, obj.rated_voltage_V/2);
        end
        
    end
    
end
